/*
 * Decompiled with CFR 0.152.
 */
package com.james.tinkerscalibration.modifiers.armor;

import com.james.tinkerscalibration.TinkersCalibrationArmorModifiers;
import java.util.UUID;
import java.util.function.BiConsumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEvent;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.behavior.AttributesModifierHook;
import slimeknights.tconstruct.library.modifiers.modules.technical.ArmorLevelModule;
import slimeknights.tconstruct.library.module.HookProvider;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.capability.TinkerDataCapability;
import slimeknights.tconstruct.library.tools.context.EquipmentContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import twilightforest.world.registration.TFGenerationSettings;

public class ArmorTwilitModifier
extends Modifier
implements AttributesModifierHook {
    private static final ResourceLocation KEY = new ResourceLocation("tinkerscalibration", "armor_twilit");
    private static final TinkerDataCapability.TinkerDataKey<Integer> TWILIT = TConstruct.createKey((String)"twilit_armor");

    public ArmorTwilitModifier() {
        MinecraftForge.EVENT_BUS.addListener(ArmorTwilitModifier::onUpdateApply);
    }

    public void addAttributes(IToolStackView tool, ModifierEntry modifier, EquipmentSlot slot, BiConsumer<Attribute, AttributeModifier> consumer) {
        if (tool.getPersistentData().getFloat(KEY) == 1.0f) {
            consumer.accept(Attributes.f_22285_, new AttributeModifier(UUID.fromString("8abecfa7-84ec-43b7-8820-8289090b80db"), Attributes.f_22285_.m_22087_(), 2.0, AttributeModifier.Operation.ADDITION));
        } else {
            consumer.accept(Attributes.f_22284_, new AttributeModifier(UUID.fromString("b845482e-3ddf-416e-aeba-861644081d42"), Attributes.f_22285_.m_22087_(), 2.0, AttributeModifier.Operation.ADDITION));
        }
    }

    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        hookBuilder.addHook((Object)this, ModifierHooks.ATTRIBUTES);
        hookBuilder.addModule((HookProvider)new ArmorLevelModule(TWILIT, false, null));
    }

    private static void onUpdateApply(LivingEvent.LivingTickEvent evt) {
        EquipmentContext context;
        LivingEntity living = evt.getEntity();
        if (!living.m_5833_() && (context = new EquipmentContext(living)).hasModifiableArmor() && !living.f_19853_.f_46443_ && living.m_6084_()) {
            living.getCapability(TinkerDataCapability.CAPABILITY).ifPresent(holder -> {
                int level = (Integer)holder.get(TWILIT, (Object)0);
                if (level > 0) {
                    ArmorTwilitModifier.addPersistentData(context, living);
                }
            });
        }
    }

    public static void addPersistentData(EquipmentContext context, LivingEntity living) {
        IToolStackView level4;
        IToolStackView level22;
        IToolStackView level32;
        ModDataNBT persistentData;
        ToolStack tool;
        Level world = living.m_20193_();
        IToolStackView iToolStackView = context.getToolInSlot(EquipmentSlot.LEGS);
        if (iToolStackView instanceof ToolStack) {
            tool = (ToolStack)iToolStackView;
            persistentData = tool.getPersistentData();
            int level32 = tool.getModifierLevel(TinkersCalibrationArmorModifiers.igneous.get());
            if (level32 > 0) {
                if (world.m_46472_().equals((Object)TFGenerationSettings.DIMENSION_KEY)) {
                    if (persistentData.getFloat(KEY) == 0.0f) {
                        persistentData.putFloat(KEY, 1.0f);
                    }
                } else {
                    persistentData.remove(KEY);
                }
            }
        }
        if ((level32 = context.getToolInSlot(EquipmentSlot.HEAD)) instanceof ToolStack) {
            tool = (ToolStack)level32;
            persistentData = tool.getPersistentData();
            int level22 = tool.getModifierLevel(TinkersCalibrationArmorModifiers.igneous.get());
            if (level22 > 0) {
                if (world.m_46472_().equals((Object)TFGenerationSettings.DIMENSION_KEY)) {
                    if (persistentData.getFloat(KEY) == 0.0f) {
                        persistentData.putFloat(KEY, 1.0f);
                    }
                } else {
                    persistentData.remove(KEY);
                }
            }
        }
        if ((level22 = context.getToolInSlot(EquipmentSlot.CHEST)) instanceof ToolStack) {
            tool = (ToolStack)level22;
            persistentData = tool.getPersistentData();
            int level4 = tool.getModifierLevel(TinkersCalibrationArmorModifiers.igneous.get());
            if (level4 > 0) {
                if (world.m_46472_().equals((Object)TFGenerationSettings.DIMENSION_KEY)) {
                    if (persistentData.getFloat(KEY) == 0.0f) {
                        persistentData.putFloat(KEY, 1.0f);
                    }
                } else {
                    persistentData.remove(KEY);
                }
            }
        }
        if ((level4 = context.getToolInSlot(EquipmentSlot.FEET)) instanceof ToolStack) {
            tool = (ToolStack)level4;
            persistentData = tool.getPersistentData();
            int level5 = tool.getModifierLevel(TinkersCalibrationArmorModifiers.igneous.get());
            if (level5 > 0) {
                if (world.m_46472_().equals((Object)TFGenerationSettings.DIMENSION_KEY)) {
                    if (persistentData.getFloat(KEY) == 0.0f) {
                        persistentData.putFloat(KEY, 1.0f);
                    }
                } else {
                    persistentData.remove(KEY);
                }
            }
        }
    }
}

